option explicit 'variables have to be declared

'print indroduction
Wscript.echo vbCrLf
Wscript.echo "============================="
Wscript.echo "= Example automation script ="
Wscript.echo "============================="
Wscript.echo "Copy a template operation to target operation and run it"
Wscript.echo "Klippel GmbH, Germany, last edit: 08/2014"
Wscript.echo vbCrLf
Wscript.echo vbCrLf

'===============================================================================
'=======        variables, arguments, default paths and timestamp        =======
'===============================================================================

'Declare variables
dim pathToDatabase,db , fso                                             'path to database, database object and file system object
dim templatePath,  templateFolder,  templateDriver,  templateOperation  'strings for path to template inside database
dim templateNodeObj                                                     'the template node as object
dim targetPath,    targetFolder,    targetDriver,    targetOperation    'strings for path to target inside database
dim targetPathObj, targetFolderObj, targetDriverObj, targetOperationObj 'objects for path to target (maybe they need to be created)
dim calOperationObj                                                     'the CAL operation
dim now_date, now_time, timestamp                                       'timestamp and parts of it
dim spaces                                                              'a string that will containing a lot of spaces

spaces = String(30, " ")

'get timestamp
now_date = Date()
now_time = Time()
timestamp = Year(now_date) & "-" & right("0" & Month(now_date), 2) & "-" & right("0" & Day(now_date), 2) & " " & right("0" & Hour(now_time), 2) & ":" & right("0" & Minute(now_time), 2) & ":" & right("0" & Second(now_time), 2)

'check and get arguments
if WScript.Arguments.Count < 1 then
   'print usage and leave
   Wscript.echo "Usage:"
   Wscript.echo vbTab & "cscript.exe  AddStatistic.vbs D:\Path\To\Database.kdbx"
   Wscript.echo " or"
   Wscript.echo vbTab & "cscript.exe  AddStatistic.vbs D:\Path\To\Database.kdbx TemplateOperationPath"
   Wscript.echo " or"
   Wscript.echo vbTab & "cscript.exe  AddStatistic.vbs D:\Path\To\Database.kdbx TemplateOperationPath TargetOperationPath"
   WScript.Arguments.Count
   WScript.Quit 1
else
   pathToDatabase = Wscript.Arguments.Item(0) 'get from first argument
end if

if WScript.Arguments.Count < 2 then
   templateFolder    = ""
   templateDriver    = "template"
   templateOperation = "daily"
else
   templatePath      = split(Wscript.Arguments.Item(1),"\") 'get from second argument
   if ubound(templatePath)<>2 then
      Wscript.echo "ERROR: Invalid path syntax: """ & Wscript.Arguments.Item(1) & """"
      Wscript.echo "Be sure to use exactly two backslashes to separate Folder\Driver\Operation."
      Wscript.echo "(Example: ""Folder\Driver\Operation"" or ""\Folder\Driver"")"
      Wscript.quit 1
   end if
   templateFolder    = templatePath(0)
   templateDriver    = templatePath(1)
   templateOperation = templatePath(2)
end if

if WScript.Arguments.Count < 3 then
   targetFolder    = ""
   targetDriver    = "Statistics"
   targetOperation = timestamp
else
   targetPath      = split(Wscript.Arguments.Item(2),"\") 'get from third argument
   if ubound(targetPath)<>2 then
      Wscript.echo "ERROR: Invalid path syntax: """ & Wscript.Arguments.Item(2) & """"
      Wscript.echo "Be sure to use exactly two backslashes to separate Folder\Driver\Operation."
      Wscript.echo "(Example: ""Folder\Driver\Operation"" or ""Folder\Driver\"" or ""\Driver\"")"
      Wscript.quit 1
   end if
   targetFolder    = targetPath(0)
   targetDriver    = targetPath(1)
   targetOperation = targetPath(2)
end if
if targetDriver    = empty    then  targetDriver    = "Statistics"  end if 'default target driver
if targetOperation = empty    then  targetOperation = timestamp     end if 'default target operation

'print current configuration
Wscript.echo left("Path to database:"   & spaces, 25) & pathToDatabase
Wscript.echo left("Template operation:" & spaces, 25) & templateFolder & "\" & templateDriver & "\" & templateOperation
Wscript.echo left("Target operation:"   & spaces, 25) & targetFolder   & "\" & targetDriver   & "\" & targetOperation
Wscript.echo vbCrLf

'===============================================================================
'=======                 open database, template and target node         =======
'===============================================================================

'get the file system object for file operations
Set fso = CreateObject("Scripting.FileSystemObject")
'check the existence of the example database file
if not fso.FileExists(pathToDatabase) then
   Wscript.echo "ERROR: Cannot find database file: " & pathToDatabase & vbCrLf & "exiting."
   WScript.quit 1
end if

'create a new KlDatabase object
Set db = CreateObject("KlAutomation.KlDatabase.1")
'something is wrong, bail out
if db is nothing then
   Wscript.echo "ERROR: Cannot get new database object" & vbCrLf & "exiting."
   WScript.quit 1
end if

'open the database
db.Open pathToDatabase

'Get template operation node
Set templateNodeObj = db.GetNode(templateFolder & "\" & templateDriver & "\" & templateOperation)

'Error message, if node not found
if templateNodeObj is nothing then
   Wscript.echo "ERROR: Cannot find template node: " & templateFolder & "\" & templateDriver & "\" & templateOperation & vbCrLf & "exiting."
   WScript.Quit 1
end if

'target folder
Set targetFolderObj = db.GetNode(targetFolder)
if targetFolderObj is nothing then
   Wscript.echo "Creating folder: " & targetFolder
   Set targetFolderObj = db.Root.CreateFolder(targetFolder)
end if

'target driver
Set targetDriverObj = db.GetNode(targetFolder & "\" & targetDriver)
if targetDriverObj is nothing then
   Wscript.echo "Creating driver: " & targetDriver
   Set targetDriverObj = targetFolderObj.CreateDriver(targetDriver)
end if

'target operation
set targetOperationObj = templateNodeObj.CopyTo(targetDriverObj,0)
targetOperationObj.name = targetOperation
Set calOperationObj = targetOperationObj.LoadInstance

'===============================================================================
'=======                 change parameters, run and exit                 =======
'===============================================================================
calOperationObj.Setup("StatName") = "Daily statistic " & targetOperation

'Run
Wscript.echo "Starting CAL operation"
if Not calOperationObj.isRunning then
  if Not calOperationObj.start then
    Wscript.echo "Cannot start CAL Operation"
    WScript.Quit 1
  end if
end if

while calOperationObj.isRunning
    WScript.Sleep 300
wend
Wscript.echo "CAL operation finished."

'detach the cal module from the database node and let the module alone
targetOperationObj.ReleaseInstance

'close database
db.Close
Wscript.echo "Goodbye."
